#include "displayHelpers.h"
#include <Wire.h>
#include <U8g2lib.h>

U8G2_SSD1306_128X32_UNIVISION_F_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE, /* clock=*/ SCL, /* data=*/ SDA);

void initDisplay(){
  u8g2.begin();
  delay(100);
  u8g2.setDisplayRotation(U8G2_R2);
  u8g2.clearBuffer();
}

void displayStatusMsg(String msg){
  u8g2.clearBuffer();          // clear the internal memory
  u8g2.setFont(u8g2_font_ncenB14_tr);
  u8g2.setCursor(0, 24);
  u8g2.print(msg);
  u8g2.sendBuffer();
}

void clearDisplay(){
  u8g2.clearBuffer();
  u8g2.sendBuffer();
}

void displayRange(String title,int lower, int upper, int center){
  u8g2.clearBuffer();
  u8g2.setFont(u8g2_font_ncenB08_tr);
  u8g2.setCursor(0, 8);
  u8g2.print(title);
  u8g2.setCursor(0, 20);
  u8g2.print("< min  | center |  max >");
  u8g2.setCursor(0, 32);
  u8g2.print("  ");
  u8g2.print(lower);
  u8g2.print(" | ");
  u8g2.print(center);
  u8g2.print(" | ");
  u8g2.print(upper);
  u8g2.sendBuffer();
}

void displayRemainingTime(int seconds){
    u8g2.setCursor(50, 31);
    u8g2.print(u8x8_u8toa(seconds, 2));
    u8g2.print(" s");
    u8g2.sendBuffer();
    Serial.print(seconds);Serial.println(" s remaining  ");
}

void displayMaxCalibrationMessage(){
  Serial.println("Calibrating limits");
  u8g2.clearBuffer();
  u8g2.setFont(u8g2_font_ncenB08_tr);
  u8g2.setCursor(16, 10);
  u8g2.print("Move Handlebar");
  u8g2.setCursor(20, 20);
  u8g2.print("<- min / max ->");
  u8g2.sendBuffer();
  Serial.println("Move to limits");
}

void displayCenterCalibrationMessage(){
  Serial.println("Calibrating center");
  u8g2.clearBuffer();
  u8g2.setFont(u8g2_font_ncenB08_tr);
  u8g2.setCursor(14, 10);
  u8g2.print("Center Handlebar");
  u8g2.setCursor(42, 20);
  u8g2.print("->  0  <-");
  u8g2.sendBuffer();
}
