#include "WorldHelpers.h"

bool teleport(int locationId) {

	Entity teleportEntity = PLAYER::PLAYER_PED_ID();

	ENTITY::SET_ENTITY_COORDS_NO_OFFSET(teleportEntity, locations[locationId].x, locations[locationId].y, locations[locationId].z, 0, 0, 1);

	return 1;
}

void setupPlayer() {
	Player player = PLAYER::PLAYER_ID();
	PLAYER::SET_PLAYER_INVINCIBLE(player, FALSE);
	PLAYER::SET_POLICE_IGNORE_PLAYER(player, true);
	PED::SET_CREATE_RANDOM_COPS(false);
}

void setupEnvironment() {
	TIME::SET_CLOCK_TIME(12, 0, 0);
	GAMEPLAY::SET_OVERRIDE_WEATHER("CLEAR");
	TIME::PAUSE_CLOCK(true);
}

void updatePlayerFeatures()
{
	// wait until player is ready, basicly to prevent using the trainer while player is dead or arrested
	while (ENTITY::IS_ENTITY_DEAD(PLAYER::PLAYER_PED_ID()) || PLAYER::IS_PLAYER_BEING_ARRESTED(PLAYER::PLAYER_ID(), TRUE))
		WAIT(0);

	Player player = PLAYER::PLAYER_ID();
	Ped playerPed = PLAYER::PLAYER_PED_ID();
	BOOL bPlayerExists = ENTITY::DOES_ENTITY_EXIST(playerPed);


	if (bPlayerExists) {
		PLAYER::SET_PLAYER_INVINCIBLE(player, TRUE);
		PLAYER::CLEAR_PLAYER_WANTED_LEVEL(player);
	}
}

void spawnBike() {
	DWORD model = GAMEPLAY::GET_HASH_KEY("CRUISER");
	if (STREAMING::IS_MODEL_IN_CDIMAGE(model) && STREAMING::IS_MODEL_A_VEHICLE(model))
	{
		STREAMING::REQUEST_MODEL(model);
		while (!STREAMING::HAS_MODEL_LOADED(model)) WAIT(0);
		Vector3 coords = ENTITY::GET_OFFSET_FROM_ENTITY_IN_WORLD_COORDS(PLAYER::PLAYER_PED_ID(), 0.0, 5.0, 0.0);
		Vehicle veh = VEHICLE::CREATE_VEHICLE(model, coords.x, coords.y, coords.z, 0.0, 1, 1);
	}
}