#include "TruckList.h"

//unsigned long 
// offset to negative hashes = 4.294.967.296
#define OFFSET  4294967296
std::list<Hash> truckModels = {
	//Manual search
	2971866336,//towtruck

	//----
	2053223216,//Benson
	850991848,//Biff
	2307837162,//Boxville 1
	4061868990,//Boxville 2
	121658888,//Boxville 3
	444171386,//Boxville 4
	682434785,//Boxville 5
	3288047904,//Cutter
	3410276810,//Docktug (small)
	2164484578,//Dump
	1353720154,//Flatbed  1353720154
	444583674,//Handler
	1518533038,//Hauler
	387748548,//Hauler2
	3510150843,//Mixer
	475220373,//Mixer2
	904750859,//Mule
	3244501995,//Mule2
	2242229361,//Mule3
	569305213,//Packer
	2157618379,//Phantom
	2645431192,//Phantom2
	177270108,//Phantom 3
	2112052861, //Pounder
	//-----------------//
	//industrial
	//OFFSET-947761570,//-947761570,//tiptruck2
	48339065,//tiptruck
	2594165727,//Scrap Truck
	3347205726,//Tipper Inustrie
	2222034228,//Bus
	2589662668//Tipper with rubble
	//OFFSET4294967296-1705304628,//rubble
	//OFFSET-784816453//mixer
	//4294967296 + 475220373//mixer2

};

std::string toFixedLengthNumberString(int number, int length) {
	std::stringstream ss;
	ss << std::setw(length) << std::setfill('0') << number;
	return ss.str();
}

std::string listEntryToCsv(TruckListEntry truck) {
	std::stringstream ss;
	ss << toFixedLengthNumberString(truck.id, 6) << "," <<
		toFixedLengthNumberString(truck.distanceToPlayer, 3) << "," <<
		toFixedLengthNumberString(truck.angleToPlayer, 3) << "," <<
		toFixedLengthNumberString(truck.heading, 3) << "," <<
		toFixedLengthNumberString(truck.velocity, 2) <<
		std::endl;

	return ss.str();
}

void debugPrintTruckList(std::list<TruckListEntry> truckList) {
	std::cout << "Found" << truckList.size() << " trucks " << std::endl;
	std::cout << "ID, distance [m],angleToPlayer [deg],heading [deg],speed [m/s] " << std::endl;
	if (truckList.size() > 0) {
		for (TruckListEntry truck : truckList) {
			std::cout << listEntryToCsv(truck);
		}
	}
}

bool isTruck(Vehicle vehicle) {
	unsigned long vHash = ENTITY::GET_ENTITY_MODEL(vehicle);
	std::cout << vHash << std::endl;
	for (Hash i : truckModels) {
		if ((UINT32)i == (UINT32)vHash) {
			return true;
		}
	}
	return false;
}