#include "MathHelpers.h"
#include <cmath>
#include<stdio.h>
#include <iostream>

int toClockwiseAngle(int heading) {
	return 360 - heading;
}

int toSpeed(Vector3 velocity) {
	return sqrt(pow(velocity.x, 2) + pow(velocity.y, 2));
}

int toRelativeHeading(int playerRot, int objRot) {
	int relativeHeading = objRot - playerRot;
	if (relativeHeading < 0) {
		relativeHeading += 360;
	}
	return relativeHeading;
}


#define PI 3.14159265
int  toAngleToPlayer(int playerHeading, Vector3 playerPosition, Vector3 objectPosition) {
	Vector3 vector;
	vector.x = objectPosition.x - playerPosition.x;
	vector.y = objectPosition.y - playerPosition.y;

	int angle = 0;

	if (vector.y == 0) {
		if (vector.x > 0) {
			angle = 90;
		}
		else if (vector.x < 0) {
			angle = 270;
		}
		else {
			angle = 0;
		}
	}
	else {
		angle = float(atan(vector.x / vector.y) * 180) / PI;
		if (vector.x > 0 && (vector.y < 0)) {
			angle = 180 + angle;
		}
		else if (vector.x < 0 && vector.y < 0) {
			angle = angle + 180;
		}
		else if (vector.x < 0 && vector.y > 0) {
			angle = angle + 360;
		}
	}

	int angleToPlayer = angle - playerHeading;

	std::cout << "playerHeading: " << playerHeading << std::endl;
	std::cout << "vector.x: " << vector.x << std::endl;
	std::cout << "vector.y: " << vector.y << std::endl;
	std::cout << "angle" << angle << std::endl;
	std::cout << "angleToPlayer" << angleToPlayer << std::endl;

	if (angleToPlayer < 0) {
		angleToPlayer += 360;
	}
	return angleToPlayer;
}