#ifndef INPUT_HELPERS_H
#define INPUT_HELPERS_H

#include "config.h"
#include <Arduino.h>

struct potiRange{
  int lowerLimit;
  int upperLimit;
  int center;
};

void setupSensors();
void storeRanges();
void loadRanges();
void calibrate();
int getSteeringInput();
int getBrakingInput();
int getModifiedSteering(int input);

//Private helpers
potiRange updateRange(uint16_t inputValue, potiRange range);
void resetRange(potiRange &range);
int toNormalizedValueNoMidpoint(uint16_t analogValue,potiRange range);
int toNormalizedValue(uint16_t analogValue,potiRange range);
void printToDisplay(String msg);
#endif
