char debugMessage[100];

void print_debug() {

	UI::SET_TEXT_FONT(0);
	UI::SET_TEXT_SCALE(0.55, 0.55);
	UI::SET_TEXT_COLOUR(255, 255, 255, 255);
	UI::SET_TEXT_WRAP(0.0, 1.0);
	UI::SET_TEXT_CENTRE(1);
	UI::SET_TEXT_DROPSHADOW(0, 0, 0, 0, 0);
	UI::SET_TEXT_EDGE(1, 0, 0, 0, 205);
	UI::_SET_TEXT_ENTRY("STRING");
	UI::_ADD_TEXT_COMPONENT_STRING(debugMessage);
	UI::_DRAW_TEXT(0.5, 0.5);
}

// Data sharing functions OUTPUT from GTA5 to external devices
// Doesnt work
int testUart()
{
	HANDLE hComm;
	TCHAR* pcCommPort = TEXT("COM10"); //  Most systems have a COM1 port
	hComm = CreateFileA(pcCommPort,                //port name
		GENERIC_READ | GENERIC_WRITE, //Read/Write
		0,                            // No Sharing
		NULL,                         // No Security
		OPEN_EXISTING,// Open existing port only
		0,            // Non Overlapped I/O
		NULL);        // Null for Comm Devices

	if (hComm == INVALID_HANDLE_VALUE) {
		sprintf(debugMessage, "%p", hComm);
		std::cout << "opening serial port failed" << std::endl;
	}
	else {
		std::cout << "opening serial port successful" << std::endl;
		sprintf(debugMessage, "opening serial port successful");
		// Do some basic settings
		DCB serialParams = { 0 };
		serialParams.DCBlength = sizeof(serialParams);

		GetCommState(hComm, &serialParams);
		serialParams.BaudRate = 9600;
		serialParams.ByteSize = 8;
		serialParams.StopBits = 0;
		serialParams.Parity = false;
		SetCommState(hComm, &serialParams);

		// Set timeouts
		COMMTIMEOUTS timeout = { 0 };
		timeout.ReadIntervalTimeout = 50;
		timeout.ReadTotalTimeoutConstant = 50;
		timeout.ReadTotalTimeoutMultiplier = 50;
		timeout.WriteTotalTimeoutConstant = 50;
		timeout.WriteTotalTimeoutMultiplier = 10;

		SetCommTimeouts(hComm, &timeout);

		char str[] = "Example text testing WriteFile";
		DWORD bytesWritten;

		WriteFile(hComm, str, strlen(str), &bytesWritten, NULL);

	}
		

	//CloseHandle(hComm);//Closing the Serial Port

	return 0;
}

//Doesnt work
int testFile()
{
	// Open a handle to the file
	HANDLE hFile = CreateFile(
		"NewFile.txt",     // Filename
		GENERIC_WRITE,          // Desired access
		FILE_SHARE_READ,        // Share mode
		NULL,                   // Security attributes
		CREATE_NEW,             // Creates a new file, only if it doesn't already exist
		FILE_ATTRIBUTE_NORMAL,  // Flags and attributes
		NULL);                  // Template file handle

	if (hFile == INVALID_HANDLE_VALUE)
	{
		std::cout << "Failed to open/create file" << std::endl;// Failed to open/create file
		return 2;
	}

	// Write data to the file
	std::string strText = "Hello World!"; // For C use LPSTR (char*) or LPWSTR (wchar_t*)
	DWORD bytesWritten;
	WriteFile(
		hFile,            // Handle to the file
		strText.c_str(),  // Buffer to write
		strText.size(),   // Buffer size
		&bytesWritten,    // Bytes written
		nullptr);         // Overlapped

	 // Close the handle once we don't need it.
	CloseHandle(hFile);
}

#include <conio.h>
#include <tchar.h>

#define BUF_SIZE 256
TCHAR szName[] = TEXT("Global\\MyFileMappingObject");
TCHAR szMsg[] = TEXT("Message from first process.");
// doesnt work
void testSharedMemory() {
	HANDLE hMapFile;
	LPCTSTR pBuf;

	hMapFile = CreateFileMapping(
		INVALID_HANDLE_VALUE,    // use paging file
		NULL,                    // default security
		PAGE_READWRITE,          // read/write access
		0,                       // maximum object size (high-order DWORD)
		BUF_SIZE,                // maximum object size (low-order DWORD)
		szName);                 // name of mapping object

	if (hMapFile == NULL)
	{
		_tprintf(TEXT("Could not create file mapping object (%d).\n"),
			GetLastError());
		return;
	}
	pBuf = (LPTSTR)MapViewOfFile(hMapFile,   // handle to map object
		FILE_MAP_ALL_ACCESS, // read/write permission
		0,
		0,
		BUF_SIZE);

	if (pBuf == NULL)
	{
		_tprintf(TEXT("Could not map view of file (%d).\n"),
			GetLastError());

		CloseHandle(hMapFile);

		return;
	}


	CopyMemory((PVOID)pBuf, szMsg, (_tcslen(szMsg) * sizeof(TCHAR)));
	_getch();

	UnmapViewOfFile(pBuf);

	CloseHandle(hMapFile);
	
}

void draw_status_text() {
	char text[50];

	UI::SET_TEXT_FONT(0);
	UI::SET_TEXT_SCALE(0.55, 0.55);
	UI::SET_TEXT_COLOUR(255, 255, 255, 255);
	UI::SET_TEXT_WRAP(0.0, 1.0);
	UI::SET_TEXT_CENTRE(1);
	UI::SET_TEXT_DROPSHADOW(0, 0, 0, 0, 0);
	UI::SET_TEXT_EDGE(1, 0, 0, 0, 205);
	UI::_SET_TEXT_ENTRY("STRING");
	UI::_ADD_TEXT_COMPONENT_STRING(text);
	UI::_DRAW_TEXT(0.5, 0.5);

}

void show_closest_vehicle() {
	Entity playerEntity = PLAYER::PLAYER_PED_ID();
	Vehicle vehicle = getClosestVehicleFromPedPos(PLAYER::GET_PLAYER_PED(-1), 100, 5, false);

	UINT32 vHash = ENTITY::GET_ENTITY_MODEL(vehicle);
	VEHICLE::GET_DISPLAY_NAME_FROM_VEHICLE_MODEL(vHash);
}
