#pragma once

#include <sstream>
#include <iomanip>
#include <list>
#include <iostream>
#include "..\inc\natives.h"
#include "..\inc\types.h"
#include "..\inc\enums.h"

/*****      Truck Stuff      *****/
struct TruckListEntry {
	int id; // 6 Characters
	int distanceToPlayer; // [m] 3 Characters (0-999)
	int angleToPlayer; // [deg] 3 Characters (0-360)
	int heading; // [deg] 3 Characters (0-360)
	int velocity; // [m/s] 2 Characters (0-99)
};

std::string toFixedLengthNumberString(int number, int length);
std::string listEntryToCsv(TruckListEntry truck);
void debugPrintTruckList(std::list<TruckListEntry> truckList);
bool isTruck(Vehicle vehicle);